IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Contratos_Baja_Prog') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_Contratos_Baja_Prog
END
GO

CREATE PROCEDURE CP_Contratos_Baja_Prog 
AS
BEGIN TRY
	SET NOCOUNT ON
	BEGIN TRAN
	DECLARE @Sql			VARCHAR(MAX)
	DECLARE @Cant			INT
	DECLARE @Cant_CS		INT
	DECLARE @Tipo_Cont_CS	VARCHAR(1000)

	CREATE TABLE #Cont	(Id_Contrato INT,Id_Cliente INT,Id_Motivo_Est INT,Fecha_Baja_Prog DATETIME, Id_User INT)

	SET @Tipo_Cont_CS = RTRIM(LTRIM(ISNULL(dbo.CF_xParam('Tipo_Cont_CS'),'')))
	SET @Cant = 0
	SET @Cant_CS = 0

	IF RTRIM(LTRIM(@Tipo_Cont_CS)) = ''
	BEGIN
		INSERT #Cont 
			SELECT Id_Contrato,Id_Cliente,Id_Motivo_Est,Fecha_Baja_Prog,Id_Usuario_Baja 
				FROM Contratos 
				WHERE Activo = 1 AND Fecha_Baja_Prog IS NOT NULL AND Fecha_Baja_Prog <= GETDATE()
				

		SELECT @Cant = COUNT(*) FROM #Cont

		UPDATE Contratos SET Activo = 0, Fecha_Baja = O.Fecha_Baja_Prog, Fecha_Baja_Prog = NULL FROM Contratos O JOIN #Cont B ON O.Id_Contrato = B.Id_Contrato
	END
	ELSE
	BEGIN
	    ---------------------------------baja contratos CS
		SET @Sql = 'INSERT  #Cont  
							SELECT Id_Contrato,Id_Cliente,Id_Motivo_Est,Fecha_Baja_Prog,Id_Usuario_Baja 
								FROM Contratos 
								WHERE Activo = 1 
									AND Fecha_Baja_Prog IS NOT NULL 
									AND Fecha_Baja_Prog <= GETDATE()
									AND Id_Tipo_Con IN ('+ @Tipo_Cont_CS +')'
		EXEC(@Sql)
		SELECT @Cant_CS = COUNT(*) FROM #Cont
		UPDATE Contratos	SET Activo = 0, Fecha_Baja = B.Fecha_Baja_Prog, Fecha_Baja_Prog = NULL 
								FROM Contratos O JOIN #Cont B ON O.Id_Contrato = B.Id_Contrato
		UPDATE Clientes		SET Activo = 0, Fecha_Baja = B.Fecha_Baja_Prog ,Id_Motivo_Est = B.Id_Motivo_Est,Id_Usuario_Baja = B.Id_User
								FROM Clientes O JOIN #Cont B ON O.Id_Cliente = B.Id_Cliente
		
		
		---------------------------------baja otros contratos
		DELETE #Cont 

		SET @Sql = 'INSERT  #Cont  
							SELECT Id_Contrato,Id_Cliente,Id_Motivo_Est,Fecha_Baja_Prog,Id_Usuario_Baja 
								FROM Contratos 
								WHERE Activo = 1 
									AND Fecha_Baja_Prog IS NOT NULL 
									AND Fecha_Baja_Prog <= GETDATE()
									AND Id_Tipo_Con NOT IN ('+ @Tipo_Cont_CS +')'
		EXEC(@Sql)
		SELECT @Cant = COUNT(*) FROM #Cont
		UPDATE Contratos	SET Activo = 0, Fecha_Baja = B.Fecha_Baja_Prog, Fecha_Baja_Prog = NULL 
								FROM Contratos O JOIN #Cont B ON O.Id_Contrato = B.Id_Contrato

	END





	COMMIT
	SELECT	 0						AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,@Cant + @Cant_CS	AS ErrorLine		
				,'Contratos dados de baja: '+ CONVERT(VARCHAR,@Cant + @Cant_CS)	AS ErrorMessage

	IF OBJECT_ID (N'#Cont', N'U') IS NOT NULL  DROP TABLE #Cont
	
END TRY
BEGIN CATCH

	EXECUTE usp_GetErrorInfo

	ROLLBACK
	IF OBJECT_ID (N'#Cont', N'U') IS NOT NULL  DROP TABLE #Cont

	RETURN 9999

END CATCH



/*


EXEC CP_Contratos_Baja_Prog


*/